using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using ToDos.Business.Abstractions;
using ToDos.Business.Services;
using ToDos.Data.Extensions;

namespace ToDos.Business;

public static class DependencyInjection
{
    public static IServiceCollection AddTodoApp(this IServiceCollection services, IConfiguration configuration)
    {
        services.AddDataAccess(configuration);
        services.AddScoped<ITodoService, TodoService>();
        return services;
    }
}
