using ToDos.Business.Abstractions;
using ToDos.Business.Models;
using ToDos.Data.Entities;
using ToDos.Data.Models;
using ToDos.Data.Repositories;

namespace ToDos.Business.Services;

public class TodoService : ITodoService
{
    private readonly ITodoRepository _repo;

    public TodoService(ITodoRepository repo)
    {
        _repo = repo;
    }

    public async Task<List<TodosVM>> GetTodosAsync(TodoFilter filter)
    {
        var query = new TodoQuery
        {
            Search = filter.Search,
            IsDone = filter.IsDone,
            PlanifFrom = filter.PlanifFrom,
            PlanifTo = filter.PlanifTo,
            DoneFrom = filter.DoneFrom,
            DoneTo = filter.DoneTo
        };

        var entities = await _repo.GetTodosAsync(query);
        return entities.Select(MapToVm).ToList();
    }

    public async Task AddTodoAsync(TodosVM todo)
    {
        await _repo.AddAsync(MapToEntity(todo));
    }

    public async Task UpdateTodoAsync(TodosVM todo)
    {
        await _repo.UpdateAsync(MapToEntity(todo));
    }

    public Task DeleteTodoAsync(int id) => _repo.DeleteAsync(id);

    private static TodosVM MapToVm(TodoEntity e) => new()
    {
        Id = e.Id,
        Libelle = e.Libelle,
        Commentaire = e.Commentaire,
        Date_planif = e.Date_planif,
        Date_realisation = e.Date_realisation
    };

    private static TodoEntity MapToEntity(TodosVM vm) => new()
    {
        Id = vm.Id,
        Libelle = vm.Libelle,
        Commentaire = vm.Commentaire,
        Date_planif = vm.Date_planif,
        Date_realisation = vm.Date_realisation
    };
}
