using ToDos.Data.Entities;
using ToDos.Data.Models;

namespace ToDos.Data.Repositories;

public interface ITodoRepository
{
    Task<List<TodoEntity>> GetTodosAsync(TodoQuery query);
    Task<TodoEntity?> GetByIdAsync(int id);
    Task AddAsync(TodoEntity entity);
    Task UpdateAsync(TodoEntity entity);
    Task DeleteAsync(int id);
}
